#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>
#AutoIt3Wrapper_Version=b

_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $bExit
Global Const $fPI = ACos(-1), $fRad = $fPI / 180, $sTitle = "GDI+ Wave v1.1.2 / FPS: "
AutoItSetOption("GUIOnEventMode", 1)

GDIPlus_Wave()

AutoItSetOption("GUIOnEventMode", 0)
_GDIPlus_Shutdown()
ConsoleWrite("The end." & @CRLF)

Func GDIPlus_Wave()
	$bExit = False
	Local Const $iW = 800, $iH = 600
	$hGUI = GUICreate($sTitle & 0, $iW, $iH)
	GUISetState(@SW_SHOW, $hGUI)

	Local Const $hDC = _WinAPI_GetDC($hGUI)
	Local Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
	Local Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
	Local Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
	Local Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
	_GDIPlus_GraphicsSetSmoothingMode($hCanvas, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Local Const $hBrush = _GDIPlus_BrushCreateSolid(0xFF0000FF), $hPen = _GDIPlus_PenCreate(0xFF000000, 1)

	Local Const $iDots_X = 24, $iDots_Y = 24, $iDots_Diameter = 32, $iDots_Radius = $iDots_Diameter / 2, $iDots_Distance = 22, $fRadius = 15, _
				$fFrequenz = 3
	Local $iX, $iY, $aCoords[$iDots_Y][$iDots_X][4], _
		  $iPos_X = (-$iDots_Diameter + $iW - ($iDots_Diameter + ($iDots_X - 1) * $iDots_Distance)) / 2, _
		  $iPos_Y = (-$iDots_Diameter + $iH - ($iDots_Diameter + ($iDots_Y - 1) * $iDots_Distance)) / 2

	Local Const $hBitmap_Skull = _GDIPlus_BitmapCreateFromMemory(_Skull())
	For $iY = 0 To UBound($aCoords) - 1
		For $iX = 0 To UBound($aCoords, 2) - 1
			Switch _GDIPlus_BitmapGetPixel($hBitmap_Skull, $iX, $iY)
				Case 4278190080 ;0xFFFFFFFF
					$aCoords[$iY][$iX][2] = 0xFF000000
				Case 4294967295	;0xFF000000
					$aCoords[$iY][$iX][2] = 0xFF000070
				Case Else
					$aCoords[$iY][$iX][2] = 0x40404040
			EndSwitch
		Next
	Next
	_GDIPlus_ImageDispose($hBitmap_Skull)

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)
	Local $fSpeed = -2^32 + 1

	Do
		_GDIPlus_GraphicsClear($hCanvas, 0xFF606060)

		For $iY = 0 To UBound($aCoords) - 1
			For $iX = 0 To UBound($aCoords, 2) - 1
				$aCoords[$iY][$iX][3] = Int(0x50 + Cos(($fSpeed + $iX + $iY) / $fFrequenz) * 4 * $fRadius)
				_GDIPlus_BrushSetSolidColor($hBrush, $aCoords[$iY][$iX][2] + $aCoords[$iY][$iX][3])
				_GDIPlus_GraphicsFillEllipse($hCanvas, _
															$iPos_X + $aCoords[$iY][$iX][0], _
															$iPos_Y + $aCoords[$iY][$iX][1], _
															$iDots_Diameter, $iDots_Diameter, $hBrush)
				$aCoords[$iY][$iX][0] = $iDots_Radius + $iX * $iDots_Distance + Cos(($fSpeed + $iX + $iY) / $fFrequenz) * $fRadius
				$aCoords[$iY][$iX][1] = $iDots_Radius + $iY * $iDots_Distance + Sin(($fSpeed + $iX + $iY) / $fFrequenz) * $fRadius
			Next
		Next

		$fSpeed += 0.6666

		_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)

		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_BrushDispose($hPen)
	_GDIPlus_GraphicsDispose($hCanvas)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_Wave

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc   ;==>CalcFPS

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-09-19

Func _Skull($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Skull
	$Skull &= 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAYAQMAAADaua+7AAAABlBMVEUAAAD///+l2Z/dAAAACXBIWXMAAC4jAAAuIwF4pT92AAAAZElEQVQI12N4//87w/H/jxkmf37BIMyQwqDEkMTAVMfA0PC/keHj//MMv/+/B+LnDL/nADFHOsNPjnww/jPnPsOf8vkMP5TkGSbs62VgbDjA4LjqAIPy1WcMwv9fMFz+/xJkLgCihS6ObVuzrAAAAABJRU5ErkJggg=='
	Local $bString = _WinAPI_Base64Decode($Skull)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Skull_1bit_24x24.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Skull

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode